from abaqusGui import *
from abaqusConstants import ALL
import osutils, os


###########################################################################
# Class definition
###########################################################################

class MonolithFE2_plugin(AFXForm):

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def __init__(self, owner):
        
        # Construct the base class.
        #
        AFXForm.__init__(self, owner)
        self.radioButtonGroups = {}

        self.cmd = AFXGuiCommand(mode=self, method='MonolithFE2Module',
            objectName='monolithFE2', registerQuery=False)
        pickedDefault = ''
        if not self.radioButtonGroups.has_key('mode'):
            self.modeKw1 = AFXIntKeyword(None, 'modeDummy', True)
            self.modeKw2 = AFXStringKeyword(self.cmd, 'mode', True)
            self.radioButtonGroups['mode'] = (self.modeKw1, self.modeKw2, {})
        self.radioButtonGroups['mode'][2][106] = 'Generate a Inputscript for MonolithFE2'
        self.modeKw1.setValue(106)
        if not self.radioButtonGroups.has_key('mode'):
            self.modeKw1 = AFXIntKeyword(None, 'modeDummy', True)
            self.modeKw2 = AFXStringKeyword(self.cmd, 'mode', True)
            self.radioButtonGroups['mode'] = (self.modeKw1, self.modeKw2, {})
        self.radioButtonGroups['mode'][2][107] = 'Set Analysisparameters to control the Simulation'
        if not self.radioButtonGroups.has_key('mode'):
            self.modeKw1 = AFXIntKeyword(None, 'modeDummy', True)
            self.modeKw2 = AFXStringKeyword(self.cmd, 'mode', True)
            self.radioButtonGroups['mode'] = (self.modeKw1, self.modeKw2, {})
        self.radioButtonGroups['mode'][2][108] = 'Extract postprocessing data for a resimulation'
        if not self.radioButtonGroups.has_key('mode'):
            self.modeKw1 = AFXIntKeyword(None, 'modeDummy', True)
            self.modeKw2 = AFXStringKeyword(self.cmd, 'mode', True)
            self.radioButtonGroups['mode'] = (self.modeKw1, self.modeKw2, {})
        self.radioButtonGroups['mode'][2][109] = 'Generate Training data for ROM simulations'
        if not self.radioButtonGroups.has_key('mode'):
            self.modeKw1 = AFXIntKeyword(None, 'modeDummy', True)
            self.modeKw2 = AFXStringKeyword(self.cmd, 'mode', True)
            self.radioButtonGroups['mode'] = (self.modeKw1, self.modeKw2, {})
        self.radioButtonGroups['mode'][2][110] = 'Evaluate the training simulations'
        self.ModelnameKw = AFXStringKeyword(self.cmd, 'Modelname', True)
        self.PartnameKw = AFXStringKeyword(self.cmd, 'Partname', True)
        self.jobnameKw = AFXStringKeyword(self.cmd, 'jobname', True, 'Job-1')
        self.rve_numberKw = AFXStringKeyword(self.cmd, 'rve_number', True, '1')
        self.informationKw = AFXStringKeyword(self.cmd, 'information', True, ' ')
        self.PBCKw = AFXStringKeyword(self.cmd, 'PBC', True, '2D by selecting the edges')
        self.leftside_abqKw = AFXObjectKeyword(self.cmd, 'leftside_abq', TRUE, pickedDefault)
        self.downside_abqKw = AFXObjectKeyword(self.cmd, 'downside_abq', TRUE, pickedDefault)
        self.rightside_abqKw = AFXObjectKeyword(self.cmd, 'rightside_abq', TRUE, pickedDefault)
        self.upside_abqKw = AFXObjectKeyword(self.cmd, 'upside_abq', TRUE, pickedDefault)
        self.gen_constraintsKw = AFXBoolKeyword(self.cmd, 'gen_constraints', AFXBoolKeyword.TRUE_FALSE, True, False)
        self.schemeKw = AFXStringKeyword(self.cmd, 'scheme', True, 'staggered')
        self.convergence_ratioKw = AFXFloatKeyword(self.cmd, 'convergence_ratio', True, 1E-6)
        self.max_itersKw = AFXIntKeyword(self.cmd, 'max_iters', True, 8)
        self.save_soeKw = AFXStringKeyword(self.cmd, 'save_soe', True, 'true')
        self.indefinite_matrixKw = AFXStringKeyword(self.cmd, 'indefinite_matrix', True, 'indefinite')
        self.symmetric_matrixKw = AFXStringKeyword(self.cmd, 'symmetric_matrix', True, 'symm')
        self.solving_processKw = AFXStringKeyword(self.cmd, 'solving_process', True, 'full')
        self.macro_odbNameKw = AFXStringKeyword(self.cmd, 'macro_odbName', True)
        self.macro_modelNameKw = AFXStringKeyword(self.cmd, 'macro_modelName', True)
        self.elementKw = AFXObjectKeyword(self.cmd, 'element', TRUE, pickedDefault)
        self.integration_pointKw = AFXIntKeyword(self.cmd, 'integration_point', True, 1)
        self.sourceKw = AFXStringKeyword(self.cmd, 'source', True, 'SDV')
        self.ncpusKw = AFXIntKeyword(self.cmd, 'ncpus', True, 1)
        self.MethodKw = AFXStringKeyword(self.cmd, 'Method', True, 'ROM')
        self.training_directionsKw = AFXStringKeyword(self.cmd, 'training_directions', True, 'clustering')
        self.training_modeKw = AFXStringKeyword(self.cmd, 'training_mode', True, 'strain')
        self.nlgeomKw = AFXStringKeyword(self.cmd, 'nlgeom', True, 'YES')
        self.dtime_data_dumpKw = AFXFloatKeyword(self.cmd, 'dtime_data_dump', True, 0.1)
        self.program_directoryKw = AFXStringKeyword(self.cmd, 'program_directory', True, '')
        self.start_simulationsKw = AFXBoolKeyword(self.cmd, 'start_simulations', AFXBoolKeyword.TRUE_FALSE, True, False)
        self.odb_for_clusteringKw = AFXStringKeyword(self.cmd, 'odb_for_clustering', True)
        self.part_for_clusteringKw = AFXStringKeyword(self.cmd, 'part_for_clustering', True)
        if not self.radioButtonGroups.has_key('GroupBox_clusteringmode'):
            self.GroupBox_clusteringmodeKw1 = AFXIntKeyword(None, 'GroupBox_clusteringmodeDummy', True)
            self.GroupBox_clusteringmodeKw2 = AFXStringKeyword(self.cmd, 'GroupBox_clusteringmode', True)
            self.radioButtonGroups['GroupBox_clusteringmode'] = (self.GroupBox_clusteringmodeKw1, self.GroupBox_clusteringmodeKw2, {})
        self.radioButtonGroups['GroupBox_clusteringmode'][2][111] = 'cluster all time steps'
        self.GroupBox_clusteringmodeKw1.setValue(111)
        if not self.radioButtonGroups.has_key('GroupBox_clusteringmode'):
            self.GroupBox_clusteringmodeKw1 = AFXIntKeyword(None, 'GroupBox_clusteringmodeDummy', True)
            self.GroupBox_clusteringmodeKw2 = AFXStringKeyword(self.cmd, 'GroupBox_clusteringmode', True)
            self.radioButtonGroups['GroupBox_clusteringmode'] = (self.GroupBox_clusteringmodeKw1, self.GroupBox_clusteringmodeKw2, {})
        self.radioButtonGroups['GroupBox_clusteringmode'][2][112] = 'cluster only speficific timesteps (e.g. last one)'
        self.timestep_numbers_clusteringKw = AFXStringKeyword(self.cmd, 'timestep_numbers_clustering', True, '')
        if not self.radioButtonGroups.has_key('GroupBox_clusteringmode'):
            self.GroupBox_clusteringmodeKw1 = AFXIntKeyword(None, 'GroupBox_clusteringmodeDummy', True)
            self.GroupBox_clusteringmodeKw2 = AFXStringKeyword(self.cmd, 'GroupBox_clusteringmode', True)
            self.radioButtonGroups['GroupBox_clusteringmode'] = (self.GroupBox_clusteringmodeKw1, self.GroupBox_clusteringmodeKw2, {})
        self.radioButtonGroups['GroupBox_clusteringmode'][2][113] = 'cluster normalized values of the last timestep'
        if not self.radioButtonGroups.has_key('prescribe_number_clusters'):
            self.prescribe_number_clustersKw1 = AFXIntKeyword(None, 'prescribe_number_clustersDummy', True)
            self.prescribe_number_clustersKw2 = AFXStringKeyword(self.cmd, 'prescribe_number_clusters', True)
            self.radioButtonGroups['prescribe_number_clusters'] = (self.prescribe_number_clustersKw1, self.prescribe_number_clustersKw2, {})
        self.radioButtonGroups['prescribe_number_clusters'][2][114] = 'prescribed number of clusters:'
        self.n_clustersKw = AFXIntKeyword(self.cmd, 'n_clusters', True, 10)
        if not self.radioButtonGroups.has_key('prescribe_number_clusters'):
            self.prescribe_number_clustersKw1 = AFXIntKeyword(None, 'prescribe_number_clustersDummy', True)
            self.prescribe_number_clustersKw2 = AFXStringKeyword(self.cmd, 'prescribe_number_clusters', True)
            self.radioButtonGroups['prescribe_number_clusters'] = (self.prescribe_number_clustersKw1, self.prescribe_number_clustersKw2, {})
        self.radioButtonGroups['prescribe_number_clusters'][2][115] = 'share of error drop rate w.r.t. inital rate'
        self.prescribe_number_clustersKw1.setValue(115)
        self.cluster_rel_error_dropKw = AFXFloatKeyword(self.cmd, 'cluster_rel_error_drop', True, 0.01)
        self.n_variationsKw = AFXIntKeyword(self.cmd, 'n_variations', True, 3)
        self.stress_ampKw = AFXFloatKeyword(self.cmd, 'stress_amp', True, 1.0)
        self.strain_ampKw = AFXFloatKeyword(self.cmd, 'strain_amp', True, 0.05)
        self.simulation_timeKw = AFXFloatKeyword(self.cmd, 'simulation_time', True, 1.0)
        self.n_modesKw = AFXIntKeyword(self.cmd, 'n_modes', True, 20)
        self.NGPKw = AFXIntKeyword(self.cmd, 'NGP', True, 100)
        self.path_to_inputfileKw = AFXStringKeyword(self.cmd, 'path_to_inputfile', True, '')

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def getFirstDialog(self):

        import monolithFE2DB
        return monolithFE2DB.MonolithFE2DB(self)

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def doCustomChecks(self):

        # Try to set the appropriate radio button on. If the user did
        # not specify any buttons to be on, do nothing.
        #
        for kw1,kw2,d in self.radioButtonGroups.values():
            try:
                value = d[ kw1.getValue() ]
                kw2.setValue(value)
            except:
                pass
        return True

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def okToCancel(self):

        # No need to close the dialog when a file operation (such
        # as New or Open) or model change is executed.
        #
        return False

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Register the plug-in
#
thisPath = os.path.abspath(__file__)
thisDir = os.path.dirname(thisPath)

toolset = getAFXApp().getAFXMainWindow().getPluginToolset()
toolset.registerGuiMenuButton(
    buttonText='MonolithFE2', 
    object=MonolithFE2_plugin(toolset),
    messageId=AFXMode.ID_ACTIVATE,
    icon=None,
    kernelInitString='import monolithFE2',
    applicableModules=ALL,
    version='N/A',
    author='N/A',
    description='N/A',
    helpUrl='N/A'
)
