::#############################################################
::
:: Makefile for UMAT_Driver
::
::############################################################
::
::Main Driver script, all include files are in this folder
SET MAINSRC=UMAT_Driver.f
::
::#########change these lines when compiling with a different UMAT##################
::Main UMAT script (+UEXTERNALDB etc.)==actual UMAT
CALL :abspath UMATSRC "..\monolithfesqr\src\UMATmacro.f"
::Include all additional files needed by the actual umat => additionalSRC
CALL :abspath UELlibDIR "..\uellib\lib"
CALL :abspath UELDIR "..\uel-large-deformation\src"
CALL :abspath MATERIALDIR "..\uel-large-deformation\materialroutines\Mises"
SET additionalSRC=-I "%UELlibDIR%" -I "%UELDIR%" -I "%MATERIALDIR%"
::#########change these lines when compiling with a different UMAT##################
::
::Target file==name of Output
SET RESULT=UMAT_Driver.exe
::move to source folder
CHDIR src
::compile program
::CALL ifort %UMATSRC% %MAINSRC% -o %RESULT% -O3 -Qmkl -Qopenmp -heap-arrays %additionalSRC%
::CALL ifort %UMATSRC% %MAINSRC% %UEXTERNALDBSRC% -o %RESULT% -O3 -Qmkl -Qopenmp -heap-arrays %additionalSRC%
::  ... static linking (seems problematic with python subprocess in Abaqus
::CALL ifort /Qmkl /Qopenmp%UMATSRC% %MAINSRC% %UEXTERNALDBSRC% -o %RESULT%  %additionalSRC%
:: ... dynamic linking
CALL ifort /Qmkl /Qopenmp /MD /O3 /heap-arrays  "%UMATSRC%" %MAINSRC% -o %RESULT%  %additionalSRC%
::remove unneccesary files from compilation
DEL *.mod
DEL *.obj
::move compiled program to the binary folder
MOVE  %RESULT% ..\bin\%RESULT%
::move back the directory
CHDIR ..

::Function to get absolute path
:abspath
set %~1=%~f2
EXIT /B 0
