!DEC$ FREEFORM
!================================================================================
! Modular assembly of shape functions, quadrature rule, material
! routine and so on
!================================================================================
! Stephan Roth, 18.10.2017 (axi- and spheri-symmetric elements)
!================================================================================

INCLUDE "UXMAT1.f95"

MODULE CXU2D4PlaneStrain
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStrain, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4PlaneStrain

MODULE CXU2D4PlaneStrainReduced
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStrain, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square1GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4PlaneStrainReduced

MODULE CXU2D8PlaneStrain
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStrain, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square9GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8PlaneStrain

MODULE CXU2D8PlaneStrainReduced
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStrain, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8PlaneStrainReduced

MODULE CXU2D4PlaneStress
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStress, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UMATPS
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4PlaneStress

MODULE CXU2D4PlaneStressReduced
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStress, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square1GP
  USE UMATPS
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4PlaneStressReduced

MODULE CXU2D8PlaneStress
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStress, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square9GP
  USE UMATPS
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8PlaneStress

MODULE CXU2D8PlaneStressReduced
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStress, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UMATPS
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8PlaneStressReduced

MODULE CXU3D8
  USE ShapeFunc3D_Hex_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices3D, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr3D_Hex8GP ! For linear shape function 8 integration points provided
                      ! by Integr3D_HexRed module yield full integration scheme
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU3D8

MODULE CXU3D20
  USE ShapeFunc3D_Hex_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices3D, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr3D_Hex27GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU3D20

MODULE CXU3D20Reduced
  USE ShapeFunc3D_Hex_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices3D, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr3D_Hex8GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU3D20Reduced

MODULE CXU3D4
  USE ShapeFunc3D_Tetrahed_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices3D, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr3D_Tetrahed1GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE

MODULE CXU3D10
  USE ShapeFunc3D_Tetrahed_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices3D, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr3D_Tetrahed4GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE

MODULE CXU2D3PlaneStrain
  USE ShapeFunc2D_Triangle_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DPlaneStrain, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Triangle1GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE

! axi-symmetric element with 4 nodes and 4 integration points
MODULE CXU2D4Axisym
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DAxisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4Axisym

! axi-symmetric element with 4 nodes and 1 integration point
MODULE CXU2D4AxisymReduced
  USE ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DAxisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square1GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D4AxisymReduced

! axi-symmetric element with 8 nodes and 9 integration points
MODULE CXU2D8Axisym
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DAxisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square9GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8Axisym

! axi-symmetric element with 8 nodes and 4 integration points
MODULE CXU2D8AxisymReduced
  USE ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices2DAxisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr2D_Square4GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU2D8AxisymReduced

! spheri-symmetric element with 2 nodes and 2 integration point
MODULE CXU1D2Spherisym
  USE ShapeFunc1D_Line_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices1DSpherisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr1D_Line2GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU1D2Spherisym

! spheri-symmetric element with 2 nodes and 1 integration point
MODULE CXU1D2SpherisymReduced
  USE ShapeFunc1D_Line_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices1DSpherisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr1D_Line1GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU1D2SpherisymReduced

! spheri-symmetric element with 3 nodes and 3 integration points
MODULE CXU1D3Spherisym
  USE ShapeFunc1D_Line_Quad_ABA, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices1DSpherisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr1D_Line3GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU1D3Spherisym

! spheri-symmetric element with 3 nodes and 2 integration points
MODULE CXU1D3SpherisymReduced
  USE ShapeFunc1D_Line_Quad_ABA, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFuncDeriv, NDIM, NNODES
  USE BMatrices1DSpherisymmetric, ONLY: BMatStrain => BMatTensSym, NDI, NSHR, SYM, PreFactor
  USE Integr1D_Line2GP
  USE UXMAT1
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: UEL
  CONTAINS
    INCLUDE "UelCXU.f95"
END MODULE CXU1D3SpherisymReduced

! Main routine with choice of element by number

SUBROUTINE UEL(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
               KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)

  USE CXU2D4PlaneStrain, ONLY: UEL1 => UEL
  USE CXU2D8PlaneStrain, ONLY: UEL2 => UEL
  USE CXU2D4PlaneStress, ONLY: UEL3 => UEL
  USE CXU3D8, ONLY: UEL4 => UEL
  USE CXU3D20, ONLY: UEL5 => UEL
  USE CXU2D4PlaneStrainReduced, ONLY: UEL6 => UEL
  USE CXU2D8PlaneStrainReduced, ONLY: UEL7 => UEL
  USE CXU2D4PlaneStressReduced, ONLY: UEL8 => UEL
  USE CXU2D8PlaneStress, ONLY: UEL9 => UEL
  USE CXU2D8PlaneStressReduced, ONLY: UEL10 => UEL
  USE CXU3D20Reduced, ONLY: UEL11 => UEL
  USE CXU2D3PlaneStrain, ONLY: UEL12 => UEL
  USE CXU3D4, ONLY: UEL13 => UEL
  USE CXU3D10, ONLY: UEL14 => UEL
  USE CXU2D4Axisym, ONLY: UEL15 => UEL
  USE CXU2D4AxisymReduced, ONLY: UEL16 => UEL
  USE CXU2D8Axisym, ONLY: UEL17 => UEL
  USE CXU2D8AxisymReduced, ONLY: UEL18 => UEL
  USE CXU1D2Spherisym, ONLY: UEL19 => UEL
  USE CXU1D2SpherisymReduced, ONLY: UEL20 => UEL
  USE CXU1D3Spherisym, ONLY: UEL21 => UEL
  USE CXU1D3SpherisymReduced, ONLY: UEL22 => UEL

  INCLUDE 'ABA_PARAM.INC'

  DIMENSION RHS(MLVARX,NRHS),AMATRX(NDOFEL,NDOFEL),PROPS(NPROPS), SVARS(NSVARS),ENERGY(8),COORDS(MCRD,NNODE),U(NDOFEL), &
            DU(MLVARX,NRHS),V(NDOFEL),A(NDOFEL),TIME(2),PARAMS(*), JDLTYP(MDLOAD,NDLOAD),ADLMAG(MDLOAD,*),DDLMAG(MDLOAD,*), &
            PREDEF(2,NPREDF,NNODE),LFLAGS(*),JPROPS(NJPROP)

  SELECT CASE( JTYPE )
    CASE (2001)
      CALL UEL1(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2002)
      CALL UEL2(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2003)
      CALL UEL3(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2004)
      CALL UEL4(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2005)
      CALL UEL5(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2006)
      CALL UEL6(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2007)
      CALL UEL7(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2008)
      CALL UEL8(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2009)
      CALL UEL9(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2010)
      CALL UEL10(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2011)
      CALL UEL11(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2012)
      CALL UEL12(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2013)
      CALL UEL13(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2014)
      CALL UEL14(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    ! axi-symmetric elements
    CASE (2015)
      CALL UEL15(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2016)
      CALL UEL16(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2017)
      CALL UEL17(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2018)
      CALL UEL18(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    ! spheri-symmetric elements
    CASE (2019)
      CALL UEL19(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2020)
      CALL UEL20(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2021)
      CALL UEL21(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2022)
      CALL UEL22(RHS,AMATRX,SVARS,ENERGY,NDOFEL,PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME,KSTEP,KINC,JELEM, &
                 PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF,LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE DEFAULT
      CALL STDB_ABQERR("Error: UEL element routine for element U%I not defined", JTYPE, 0.0, " ")
  END SELECT
END SUBROUTINE
