# Do not edit this file or it may not load correctly
# if you try to open it with the RSG Dialog Builder.

# Note: thisDir is defined by the Activator class when
#       this file gets executed

from rsg.rsgGui import *
from abaqusConstants import INTEGER, FLOAT
execDir = os.path.split(thisDir)[1]
dialogBox = RsgDialog(title='MonolithFE2 Toolbox', kernelModule='monolithFE2', kernelFunction='MonolithFE2Module', includeApplyBtn=False, includeSeparator=True, okBtnText='OK', applyBtnText='Apply', execDir=execDir)
RsgTabBook(name='TabBook_1', p='DialogBox', layout='0')
RsgTabItem(name='TabItem_1', p='TabBook_1', text='Mode')
RsgGroupBox(name='GroupBox_1', p='TabItem_1', text='General Information', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_1', text='Version 2.0', useBoldFont=False)
RsgIcon(p='GroupBox_1', fileName=r'Logo.png')
osutils.copy(os.path.join(thisDir,r'Logo.png'), dialogBox.execDir, force=True)
RsgLabel(p='GroupBox_1', text='This Plugin bundles all necessary tools to control MonolithFE2', useBoldFont=False)
RsgGroupBox(name='GroupBox_2', p='TabItem_1', text='Choose the current step:', layout='LAYOUT_FILL_X')
RsgRadioButton(p='GroupBox_2', text='Generate a Inputscript for MonolithFE2', keyword='mode', default=True)
RsgRadioButton(p='GroupBox_2', text='Set Analysisparameters to control the Simulation', keyword='mode', default=False)
RsgRadioButton(p='GroupBox_2', text='Extract postprocessing data for a resimulation', keyword='mode', default=False)
RsgRadioButton(p='GroupBox_2', text='Generate Training data for ROM simulations', keyword='mode', default=False)
RsgRadioButton(p='GroupBox_2', text='Evaluate the training simulations', keyword='mode', default=False)
RsgTabItem(name='TabItem_2', p='TabBook_1', text='General')
RsgLabel(p='TabItem_2', text='Specify the previously created RVE model:', useBoldFont=False)
RsgComboBox(name='ComboBox_1', p='TabItem_2', text='Part:', keyword='Partname', default='', comboType='MDB', repository='parts', rootText='Model:', rootKeyword='Modelname', layout='VERTICAL')
RsgSeparator(p='TabItem_2')
RsgTextField(p='TabItem_2', fieldType='String', ncols=17, labelText='Job name of the macro job:', keyword='jobname', default='Job-1')
RsgComboBox(name='ComboBox_2', p='TabItem_2', text='RVE-Number:', keyword='rve_number', default='1', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_2', text='1')
RsgListItem(p='ComboBox_2', text='2')
RsgListItem(p='ComboBox_2', text='3')
RsgListItem(p='ComboBox_2', text='4')
RsgListItem(p='ComboBox_2', text='5')
RsgSeparator(p='TabItem_2')
RsgTextField(p='TabItem_2', fieldType='String', ncols=17, labelText='RVE description:', keyword='information', default=' ')
RsgLabel(p='TabItem_2', text='The text is written into the input file for informational purposes only.', useBoldFont=False)
RsgSeparator(p='TabItem_2')
RsgGroupBox(name='GroupBox_3', p='TabItem_2', text='Note:', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_3', text='Only for meshes with one element type!', useBoldFont=False)
RsgTabItem(name='TabItem_3', p='TabBook_1', text='Boundary')
RsgComboBox(name='ComboBox_3', p='TabItem_3', text='mode:', keyword='PBC', default='2D by selecting the edges', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_3', text='2D by selecting the edges')
RsgListItem(p='ComboBox_3', text='3D - Foam GUI')
RsgListItem(p='ComboBox_3', text='3D - Micromechanics Plugin')
RsgGroupBox(name='GroupBox_4', p='TabItem_3', text='Only when being in 2D mode:', layout='LAYOUT_FILL_X')
RsgPickButton(p='GroupBox_4', text='leftside', keyword='leftside_abq', prompt='Pick an entity', entitiesToPick='MDB_MESH|NODES', numberToPick='MANY')
RsgPickButton(p='GroupBox_4', text='downside', keyword='downside_abq', prompt='Pick an entity', entitiesToPick='MDB_MESH|NODES', numberToPick='MANY')
RsgPickButton(p='GroupBox_4', text='rightside', keyword='rightside_abq', prompt='Pick an entity', entitiesToPick='MDB_MESH|NODES', numberToPick='MANY')
RsgPickButton(p='GroupBox_4', text='upside', keyword='upside_abq', prompt='Pick an entity', entitiesToPick='MDB_MESH|NODES', numberToPick='MANY')
RsgIcon(p='GroupBox_4', fileName=r'Symbolbild_fuer_Plugin.png')
osutils.copy(os.path.join(thisDir,r'Symbolbild_fuer_Plugin.png'), dialogBox.execDir, force=True)
RsgCheckButton(p='TabItem_3', text='generate constraints in CAE', keyword='gen_constraints', default=False)
RsgTabItem(name='TabItem_4', p='TabBook_1', text='Parameters')
RsgComboBox(name='ComboBox_4', p='TabItem_4', text='solution scheme:', keyword='scheme', default='staggered', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_4', text='monolithic')
RsgListItem(p='ComboBox_4', text='staggered')
RsgGroupBox(name='GroupBox_5', p='TabItem_4', text='staggered control parameters:', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_5', text='convergence criterion for the ratio of largest residual to largest nonzero force', useBoldFont=False)
RsgTextField(p='GroupBox_5', fieldType='Float', ncols=12, labelText='parameter:', keyword='convergence_ratio', default='1E-6')
RsgLabel(p='GroupBox_5', text='maximum number of iterations', useBoldFont=False)
RsgTextField(p='GroupBox_5', fieldType='Integer', ncols=12, labelText='parameter:', keyword='max_iters', default='8')
RsgGroupBox(name='GroupBox_9', p='TabItem_4', text='monolithic control parameters:', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_9', text='storing the stiffness matrix factorization for the next iteration (true is faster, but', useBoldFont=False)
RsgLabel(p='GroupBox_9', text='needs significantly more memory when not in ROM mode)', useBoldFont=False)
RsgComboBox(name='ComboBox_7', p='GroupBox_9', text='parameter:', keyword='save_soe', default='true', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_7', text='true')
RsgListItem(p='ComboBox_7', text='false')
RsgGroupBox(name='GroupBox_7', p='TabItem_4', text='solver settings:', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_7', text='assumption about the stiffness matrix definiteness', useBoldFont=False)
RsgComboBox(name='ComboBox_5', p='GroupBox_7', text='parameter:', keyword='indefinite_matrix', default='indefinite', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_5', text='indefinite')
RsgListItem(p='ComboBox_5', text='positive definite')
RsgLabel(p='GroupBox_7', text='assumption about the stiffness matrix symmetry', useBoldFont=False)
RsgComboBox(name='ComboBox_6', p='GroupBox_7', text='parameter', keyword='symmetric_matrix', default='symm', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_6', text='symm')
RsgListItem(p='ComboBox_6', text='unsymm')
RsgLabel(p='GroupBox_7', text='solution method:', useBoldFont=False)
RsgComboBox(name='ComboBox_8', p='GroupBox_7', text='parameter:', keyword='solving_process', default='full', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_8', text='full')
RsgListItem(p='ComboBox_8', text='reduced')
RsgListItem(p='ComboBox_8', text='hyperreduced')
RsgTabItem(name='TabItem_5', p='TabBook_1', text='Postprocessing')
RsgLabel(p='TabItem_5', text='Select the macro-odb to extract the load history', useBoldFont=False)
RsgComboBox(name='ComboBox_9', p='TabItem_5', text='Part:', keyword='macro_modelName', default='', comboType='ODB', repository='parts', rootText='ODB:', rootKeyword='macro_odbName', layout='HORIZONTAL')
RsgPickButton(p='TabItem_5', text='Pick an element:', keyword='element', prompt='Pick an entity', entitiesToPick='ODB_ALL|ELEMENTS', numberToPick='ONE')
RsgTextField(p='TabItem_5', fieldType='Integer', ncols=12, labelText='Specify the integration point:', keyword='integration_point', default='1')
RsgComboBox(name='ComboBox_10', p='TabItem_5', text='Get the load history from:', keyword='source', default='SDV', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_10', text='SDV')
RsgListItem(p='ComboBox_10', text='E')
RsgLabel(p='TabItem_5', text='Note in order to use SDV (solution depenend variables) as source of the load', useBoldFont=False)
RsgLabel(p='TabItem_5', text='history, SDVs must be requested as field output in the STEP. Use strains E only', useBoldFont=False)
RsgLabel(p='TabItem_5', text='for geometricalls linear simulations.', useBoldFont=False)
RsgTabItem(name='TabItem_6', p='TabBook_1', text='Training')
RsgLabel(p='TabItem_6', text='General Settings:', useBoldFont=True)
RsgTextField(p='TabItem_6', fieldType='Integer', ncols=12, labelText='Number of cpus:', keyword='ncpus', default='1')
RsgComboBox(name='ComboBox_14', p='TabItem_6', text='Method:', keyword='Method', default='ROM', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_14', text='ROM')
RsgListItem(p='ComboBox_14', text='hyperROM')
RsgGroupBox(name='GroupBox_12', p='TabItem_6', text='Training data generation:', layout='LAYOUT_FILL_X')
RsgComboBox(name='ComboBox_16', p='GroupBox_12', text='get training directions from: ', keyword='training_directions', default='clustering', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_16', text='clustering')
RsgListItem(p='ComboBox_16', text='unspecific')
RsgComboBox(name='ComboBox_13', p='GroupBox_12', text='Training mode:', keyword='training_mode', default='strain', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_13', text='stress and strain')
RsgListItem(p='ComboBox_13', text='stress')
RsgListItem(p='ComboBox_13', text='strain')
RsgComboBox(name='ComboBox_12', p='GroupBox_12', text='NLGEOM:', keyword='nlgeom', default='YES', comboType='STANDARD', repository='', rootText='', rootKeyword=None, layout='')
RsgListItem(p='ComboBox_12', text='YES')
RsgListItem(p='ComboBox_12', text='NO')
RsgTextField(p='GroupBox_12', fieldType='Float', ncols=12, labelText='data dump every x [s]:', keyword='dtime_data_dump', default='0.1')
RsgFileTextField(p='GroupBox_12', ncols=12, labelText='Path to UMAT_Driver binary:', keyword='program_directory', default='', patterns='All files (*)')
RsgCheckButton(p='GroupBox_12', text='directly start training simulations', keyword='start_simulations', default=False)
RsgGroupBox(name='GroupBox_16', p='GroupBox_12', text='Clustered training:', layout='LAYOUT_FILL_X')
RsgComboBox(name='ComboBox_15', p='GroupBox_16', text='Part:', keyword='part_for_clustering', default='', comboType='ODB', repository='parts', rootText='ODB:', rootKeyword='odb_for_clustering', layout='HORIZONTAL')
RsgRadioButton(p='GroupBox_16', text='cluster all time steps', keyword='GroupBox_clusteringmode', default=True)
RsgRadioButton(p='GroupBox_16', text='cluster only speficific timesteps (e.g. last one)', keyword='GroupBox_clusteringmode', default=False)
RsgTextField(p='GroupBox_16', fieldType='String', ncols=12, labelText='     timestep-numbers sparated by comma:', keyword='timestep_numbers_clustering', default='')
RsgRadioButton(p='GroupBox_16', text='cluster normalized values of the last timestep', keyword='GroupBox_clusteringmode', default=False)
RsgGroupBox(name='GroupBox_17', p='GroupBox_16', text='get number of clusters by', layout='LAYOUT_FILL_X')
RsgRadioButton(p='GroupBox_17', text='prescribed number of clusters:', keyword='prescribe_number_clusters', default=False)
RsgTextField(p='GroupBox_17', fieldType='Integer', ncols=12, labelText='Label:', keyword='n_clusters', default='10')
RsgRadioButton(p='GroupBox_17', text='share of error drop rate w.r.t. inital rate', keyword='prescribe_number_clusters', default=True)
RsgTextField(p='GroupBox_17', fieldType='Float', ncols=12, labelText='Label:', keyword='cluster_rel_error_drop', default='0.01')
RsgGroupBox(name='GroupBox_15', p='GroupBox_12', text='Unspecific training:', layout='LAYOUT_FILL_X')
RsgLabel(p='GroupBox_15', text='Number of variations of each component of the strain/stress tensor', useBoldFont=False)
RsgTextField(p='GroupBox_15', fieldType='Integer', ncols=12, labelText='number of variations', keyword='n_variations', default='3')
RsgTextField(p='GroupBox_15', fieldType='Float', ncols=12, labelText='Stress amplitude:', keyword='stress_amp', default='1.0')
RsgTextField(p='GroupBox_15', fieldType='Float', ncols=12, labelText='Strain amplitude:', keyword='strain_amp', default='0.05')
RsgTextField(p='GroupBox_15', fieldType='Float', ncols=12, labelText='total simulation time [s]:', keyword='simulation_time', default='1.0')
RsgGroupBox(name='GroupBox_14', p='TabItem_6', text='Training data evaluation:', layout='LAYOUT_FILL_X')
RsgTextField(p='GroupBox_14', fieldType='Integer', ncols=12, labelText='Number of modes:', keyword='n_modes', default='20')
RsgTextField(p='GroupBox_14', fieldType='Integer', ncols=12, labelText='Number of hyperintegration points:', keyword='NGP', default='100')
RsgFileTextField(p='GroupBox_14', ncols=12, labelText='micro Inputfile:', keyword='path_to_inputfile', default='', patterns='(*.FE1)')
dialogBox.show()