SUBROUTINE CheckMaterialParameters(PROPS)
    
    REAL(KIND=AbqRK),INTENT(IN):: PROPS(:)
    
    ! Check if there is a correct number of properties specified in the input file.
    if ( size(PROPS)<2 ) then
            CALL STDB_ABQERR(-3_AbqIK, "CheckMaterialParameters reports: " // &
            "Invalid number of properties in the input file, at least 2 required.", &
            0, 0.0_AbqRK, " ")
    end if
    ! Check if Young's modulus is > zero
    if (PROPS(1)<=0) then
        CALL STDB_ABQERR(-3_AbqIK, "CheckMaterialParameters reports: " // &
            "Young's modulus must be greater than zero, and it should be the first one in the list of properties.", &
            0, 0.0_AbqRK, " ")
    end if
    
    if (PROPS(2)<=-1.0 .or. PROPS(2)>=0.5) then
        CALL STDB_ABQERR(-3_AbqIK, "CheckMaterialParameters reports: " // &
        "Poisson's ratio must belong interval ]-1, 0.5[, and it should be the second one in the list of properties.", &
        0, 0.0_AbqRK, " ")
    end if
    
    if (size(PROPS)>2) then
        if (PROPS(3)<=0) then
            CALL STDB_ABQERR(-3_AbqIK, "CheckMaterialParameters reports: " // &
            "Initial yield stress must be positive and it should be the third one in the list of properties.", &
            0, 0.0_AbqRK, " ")
        end if
    end if

END SUBROUTINE
