#=============================================================================
# Monolithic FE^2
# Nils Lange, Geralf Huetter, Bjoern Kiefer
#   Nils.Lange@imfd.tu-freiberg.de, Geralf.Huetter@imfd.tu-freiberg.de, 
#   Bjoern.Kiefer@imfd.tu-freiberg.de
# distributed under CC BY-NC-SA 4.0 license
# (https://creativecommons.org/licenses/by-nc-sa/4.0/)
# Reference: 
#   N. Lange, G. Huetter, B. Kiefer: "An efficient monolithic solution scheme for FE2 problems",
#   https://arxiv.org/abs/2101.01802
#
# Further information on the implementation, structure of the source code,
# examples and tutorials can be found in the file doc/documentation.pdf
#
#=============================================================================

from abaqus import *	#import abaqus functionalities
from abaqusConstants import *

def create_FE2_material(partname,modelname,materialname,rve_number,n_materials,material_1_abq,material_2_abq=""):
	#this script creates a Material definition in Abaqus for the FE2_UMAT
	
	all_constants=[float(rve_number)] #list of constants of the UMAT
	
	material_1_abq=material_1_abq.split(',') #split string into list
	material_2_abq=material_2_abq.split(',') #split string into list
	
	all_constants.append(len(material_1_abq)) #number of material properties 1
	
	if n_materials=='2':
		all_constants.append(len(material_2_abq)) #number of material properties 2
	else:
		all_constants.append(float(0))
		
	for i in range(len(material_1_abq)):	#convert string list to float list
		all_constants.append(float(material_1_abq[i]))
		
	if n_materials=='2':
		for i in range(len(material_2_abq)): #convert string list to float list
			all_constants.append(float(material_2_abq[i]))
			
	all_constants=tuple(all_constants) #convert list to tuple
	
	#create material
	mdb.models[modelname].Material(name=materialname)
	
	#set UMAT materialConstants
	mdb.models[modelname].materials[materialname].UserMaterial(mechanicalConstants=all_constants)
	
	#request solution dependend statevariables (needed for postprocessing purposes only)
	mdb.models[modelname].materials[materialname].Depvar(n=9)
