import numpy as np
def diffuse_test(C, D, delta_t, delta_x, delta_y):
    C_n_plus_1 = C.copy()
    for i in range(1, C.shape[0] - 1):
        for j in range(1, C.shape[1] - 1):
            if C[i, j] != -1 and C[i, j] != -0.75:
                C_new[i, j] += D * delta_t * ((C[i+1, j] - 2 * C[i, j] + C[i-1, j]) / delta_x ** 2 + (C[i, j+1] - 2 * C[i, j] + C[i, j-1]) / delta_y ** 2)
    return C_n_plus_1

def test_diffusion():
    C = np.zeros((5, 5))
    C[2, 2] = 1  # Initial concentration at the center
    D = 1.0
    delta_t = 0.2  # Time step for stability
    delta_x = delta_y = 1  # Grid spacing
    C_n_plus_1 = diffuse_test(C, D, delta_t, delta_x, delta_y)
    expected_center = 1 - 4 * D * delta_t / delta_x ** 2
    expected_adjacent = D * delta_t / delta_x ** 2
    assert np.isclose(C_new[2, 2], expected_center), f"Central value should decrease to {expected_center}"
    assert np.isclose(C_new[1, 2], expected_adjacent), f"Adjacent cells should increase to {expected_adjacent}"

test_diffusion()
print("Test passed!")