!DEC$ FREEFORM
!================================================================================
! Example for modular assembly of shape functions, quadrature rule, material
! routine and so on
!
! Remark:
!  - "Implicit None" can be used in the modules of the particular elements only
!    if the actual UEL (here in "UelCXUT.f90") is completely explicitely
!    defined since "ABA_PARAM.INC" does not provide implicit definitions for
!    integer variables
!
! OPEN: data structure for call of B-Matrices
!================================================================================

INCLUDE "UXMAT1.f90"
INCLUDE "UXMAT2.f90"

!! Example element with temperature coupling

MODULE CXUT2D4M1
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFunDerivcDispl => ShapeFuncDeriv, NNODESDISPL=>NNODES, NDIM
  USE  BMatrices2DPlaneStrain,  ONLY: BmatStrain => BMatTensSym, NDI, NSHR, NTENS
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncTemp => ShapeFunc, ShapeFunDerivcTemp => ShapeFuncDeriv, NNODESTEMP=>NNODES
  USE  BMatricesScalar,  ONLY: BmatTemp => BMatScal
  USE Integr2D_Square4GP
  USE UXMAT1
!  IMPLICIT NONE
  PRIVATE
  PUBLIC::UEL
  CONTAINS
    INCLUDE "UelCXUT.f90"
END MODULE

!! with reduced integration

MODULE CXUT2D4RM1
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFunDerivcDispl => ShapeFuncDeriv, NNODESDISPL=>NNODES, NDIM
  USE  BMatrices2DPlaneStrain,  ONLY: BmatStrain => BMatTensSym, NDI, NSHR, NTENS
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncTemp => ShapeFunc, ShapeFunDerivcTemp => ShapeFuncDeriv, NNODESTEMP=>NNODES
  USE  BMatricesScalar,  ONLY: BmatTemp => BMatScal
  USE Integr2D_Square1GP
  USE UXMAT1
!  IMPLICIT NONE
  PRIVATE
  PUBLIC::UEL
  CONTAINS
    INCLUDE "UelCXUT.f90"
END MODULE

!!Quadratic ansatz functions for displacements
MODULE CXUT2D8M1
  USE  ShapeFunc2D_Square_Quadr, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFunDerivcDispl => ShapeFuncDeriv, NNODESDISPL=>NNODES, NDIM
  USE  BMatrices2DPlaneStrain,  ONLY: BmatStrain => BMatTensSym, NDI, NSHR, NTENS
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncTemp => ShapeFunc, ShapeFunDerivcTemp => ShapeFuncDeriv, NNODESTEMP=>NNODES
  USE  BMatricesScalar,  ONLY: BmatTemp => BMatScal
  USE Integr2D_Square9GP
  USE UXMAT1
!  IMPLICIT NONE
  PRIVATE
  PUBLIC::UEL
  CONTAINS
    INCLUDE "UelCXUT.f90"
END MODULE

!! Other Material routine

MODULE CXUT2D4M2
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFunDerivcDispl => ShapeFuncDeriv, NNODESDISPL=>NNODES, NDIM
  USE  BMatrices2DPlaneStrain,  ONLY: BmatStrain => BMatTensSym, NDI, NSHR, NTENS
  USE  ShapeFunc2D_Square_Lin, ONLY: ShapeFuncTemp => ShapeFunc, ShapeFunDerivcTemp => ShapeFuncDeriv, NNODESTEMP=>NNODES
  USE  BMatricesScalar,  ONLY: BmatTemp => BMatScal
  USE Integr2D_Square4GP
  USE UXMAT2
!  IMPLICIT NONE
  PRIVATE
  PUBLIC::UEL
  CONTAINS
    INCLUDE "UelCXUT.f90"
END MODULE

!! 3D

MODULE CXUT3D8RM1
  USE  ShapeFunc3D_Hex_Lin, ONLY: ShapeFuncDispl => ShapeFunc, ShapeFunDerivcDispl => ShapeFuncDeriv, NNODESDISPL=>NNODES, NDIM
  USE  BMatrices3D,  ONLY: BmatStrain => BMatTensSym, NDI, NSHR, NTENS
  USE  ShapeFunc3D_Hex_Lin, ONLY: ShapeFuncTemp => ShapeFunc, ShapeFunDerivcTemp => ShapeFuncDeriv, NNODESTEMP=>NNODES
  USE  BMatricesScalar,  ONLY: BmatTemp => BMatScal
  USE Integr3D_Hex8GP
  USE UXMAT1
!  IMPLICIT NONE
  PRIVATE
  PUBLIC::UEL
  CONTAINS
    INCLUDE "UelCXUT.f90"
END MODULE

!! Main routine with choice of element by number

SUBROUTINE UEL(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
 KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)

  USE CXUT2D4M1, ONLY: UEL1 => UEL
  USE CXUT2D4RM1, ONLY: UEL2 => UEL
  USE CXUT2D8M1, ONLY: UEL3 => UEL
  USE CXUT2D4M2, ONLY: UEL4 => UEL
  USE CXUT3D8RM1, ONLY: UEL5 => UEL

  INCLUDE 'ABA_PARAM.INC'

  DIMENSION RHS(MLVARX,*),AMATRX(NDOFEL,NDOFEL),PROPS(*), SVARS(*),ENERGY(8),COORDS(MCRD,NNODE),U(NDOFEL),&
   DU(MLVARX,*),V(NDOFEL),A(NDOFEL),TIME(2),PARAMS(*), JDLTYP(MDLOAD,*),ADLMAG(MDLOAD,*),DDLMAG(MDLOAD,*), &
   PREDEF(2,NPREDF,NNODE),LFLAGS(*),JPROPS(*)

  SELECT CASE( JTYPE )
    CASE (2001)
      CALL UEL1(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
        KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
!    CASE (2002)
!      CALL UEL2(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
!        KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2003)
      CALL UEL3(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
        KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2004)
      CALL UEL4(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
        KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
    CASE (2005)
      CALL UEL5(RHS,AMATRX,SVARS,ENERGY,NDOFEL,NRHS,NSVARS, PROPS,NPROPS,COORDS,MCRD,NNODE,U,DU,V,A,JTYPE,TIME,DTIME, &
        KSTEP,KINC,JELEM,PARAMS,NDLOAD,JDLTYP,ADLMAG,PREDEF,NPREDF, LFLAGS,MLVARX,DDLMAG,MDLOAD,PNEWDT,JPROPS,NJPROP,PERIOD)
	CASE DEFAULT
	  CALL STDB_ABQERR("Error: UEL element routine for element U%I not defined", JTYPE, 0.0, " ")
  END SELECT
END SUBROUTINE
