!DEC$ FREEFORM
!=============================================================================
! Monolithic FE^2
! Nils Lange, Geralf Huetter, Bjoern Kiefer
!   Nils.Lange@imfd.tu-freiberg.de, Geralf.Huetter@imfd.tu-freiberg.de, 
!   Bjoern.Kiefer@imfd.tu-freiberg.de
! distributed under CC BY-NC-SA 4.0 license
! (https://creativecommons.org/licenses/by-nc-sa/4.0/)
! Reference: 
!   N. Lange, G. Huetter, B. Kiefer: "An efficient monolithic solution scheme
!                                     for FE² problems",
!   DOI: https://doi.org/10.1016/j.cma.2021.113886
!   N. Lange, G. Huetter, B. Kiefer: "A monolithic hyper ROM FE² method with
!                                     clustered training at finite deformations"
!   DOI: https://doi.org/10.1016/j.cma.2023.116522
!
! Further information on the implementation, structure of the source code,
! examples and tutorials can be found in the file doc/documentation.pdf
!
!=============================================================================

INCLUDE 'mkl_spblas.f90'           !type which bundles sparse matrix in CSR form
INCLUDE 'UEL.f'                    !includes the user element library
INCLUDE 'type_analysisparameters.f'!includes the type "analysisparameters"
INCLUDE 'type_meshparameters.f'    !includes the type "meshparameters"
INCLUDE 'type_macro_GP_DATA.f'     !includes the type "macro_GP_DATA"
INCLUDE 'type_systemmatrices.f'    !includes the type "systemmatrices"
INCLUDE 'type_solver.f'            !Solver Routine interface
INCLUDE 'MonolithFE2.f'            !main FE2 program
INCLUDE 'manage_data.f'            !UEXTERNERLAB, readdata, manage_STATEV_data
