!DEC$ FREEFORM
MODULE ABQINTERFACE
   IMPLICIT DOUBLE PRECISION(a-h,o-z)
   PRIVATE
   INTEGER,PARAMETER,PUBLIC::AbqRK=KIND(r),AbqIK=KIND(i)
   PUBLIC::SPRINC,SINV,SPRIND,ROTSIG,SMAIntArrayCreate,&
           SMAIntArrayAccess,SMAIntArrayDelete,&
           SMAFloatArrayCreateSP,SMAFloatArrayCreateDP,&
           SMAFloatArrayAccess,SMAFloatArrayDelete,&
           SMAFloatArrayCreate
   INTERFACE
     SUBROUTINE SPRINC(S,PS,LSTR,NDI,NSHR)
       INCLUDE 'ABA_PARAM.INC'
       DIMENSION::S(*),PS(*)
     END SUBROUTINE
     SUBROUTINE SINV(STRESS,SINV1,SINV2,NDI,NSHR)
       INCLUDE 'ABA_PARAM.INC'
       DIMENSION::STRESS(*)
     END SUBROUTINE
     SUBROUTINE SPRIND(S,PS,AN,LSTR,NDI,NSHR)
       INCLUDE 'ABA_PARAM.INC'
       DIMENSION::S(*),PS(3),AN(3,3)
     END SUBROUTINE
     SUBROUTINE ROTSIG(S,R,SPRIME,LSTR,NDI,NSHR)
       INCLUDE 'ABA_PARAM.INC'
       DIMENSION::S(*),R(*),SPRIME(*)
     END SUBROUTINE
     FUNCTION SMAIntArrayCreate( ID, SIZE, INITVAL )
       INTEGER(KIND=8) :: SMAIntArrayCreate
       INTEGER(KIND=4) :: ID,SIZE,INITVAL
     END FUNCTION SMAIntArrayCreate
     FUNCTION SMAIntArrayAccess(ID)
        INTEGER(KIND=8) :: SMAIntArrayAccess
        INTEGER(KIND=4) :: ID
     END FUNCTION SMAIntArrayAccess
     SUBROUTINE SMAIntArrayDelete(ID)
        INTEGER(KIND=4) :: ID
     END SUBROUTINE SMAIntArrayDelete  
     FUNCTION SMAFloatArrayCreateSP( ID, SIZE, INITVAL )
        INTEGER(KIND=8) :: SMAFloatArrayCreateSP
        INTEGER(KIND=4),INTENT(IN) :: ID
        INTEGER(KIND=4),INTENT(IN) :: SIZE
        REAL(KIND=4),   INTENT(IN) :: INITVAL
     END FUNCTION SMAFloatArrayCreateSP
     FUNCTION SMAFloatArrayCreateDP( ID, SIZE, INITVAL )
        INTEGER(KIND=8) :: SMAFloatArrayCreateDP
        INTEGER(KIND=4),INTENT(IN) :: ID
        INTEGER(KIND=4),INTENT(IN) :: SIZE
        REAL(KIND=8),   INTENT(IN) :: INITVAL
     END FUNCTION SMAFloatArrayCreateDP
     FUNCTION SMAFloatArrayAccess( ID )
        INTEGER(KIND=8) :: SMAFloatArrayAccess
        INTEGER(KIND=4) :: ID
     END FUNCTION SMAFloatArrayAccess
     SUBROUTINE SMAFloatArrayDelete( ID )
        INTEGER(KIND=4) :: ID 
     END SUBROUTINE SMAFloatArrayDelete 
    END INTERFACE
    INTERFACE SMAFloatArrayCreate
       PROCEDURE SMAFloatArrayCreateSP
       PROCEDURE SMAFloatArrayCreateDP
    END INTERFACE SMAFloatArrayCreate
END MODULE

INCLUDE 'UEXTERNALDB.f'
INCLUDE 'UMAT.f'
